﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_Slajd : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {

            }

            public int id { get; set; }
            public string text { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_Slajd(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Text: Text(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
        }

        private void Text(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 1;

            XmlNode _xmlText = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Exercise_Text);

            ExerciseDataStub _loopStub = new ExerciseDataStub();
            _loopStub.id = _stubIndex;
            _loopStub.text = Gemini.Utility.XML.Node.Get.CDATA(_xmlText, String.Empty);

            ExerciseData.Add(_loopStub);
        }
    }
}
